(define/contract (training-plan nums)
  (-> (listof exact-integer?) (listof exact-integer?))
  (let ([n (length nums)])
    (if (zero? n)
        '()
        (let ([left (make-list n 1)]
              [right (make-list n 1)])
          (for ([i (in-range 1 n)])
            (list-set! left i (* (list-ref left (- i 1)) (list-ref nums (- i 1)))))
          (for ([i (in-range (- n 2) -1 -1)])
            (list-set! right i (* (list-ref right (+ i 1)) (list-ref nums (+ i 1)))))
          (for/list ([i (in-range n)])
            (* (list-ref left i) (list-ref right i))))))